//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiToolButtonBase {
    id : uiToolButton

    property string iconName
    property string text
    property alias  tooltip  : tooltip.text
    property int    iconSize : UiIcon.Icon_24x24

    property UiToolButtonVisualStyle visualStyle : null

    property bool down : false

    implicitHeight   : content.implicitHeight
    implicitWidth    : content.implicitWidth
    activeFocusOnTab : false

    UiTooltip { id : tooltip }

    Rectangle {
        id : background

        color        : UiColors.getColor(UiColors.White)
        anchors.fill : parent
        visible      : false
        antialiasing : uiToolButton.antialiasing

        states : [
            State {
                name : "pressed"
                when : uiToolButton.pressed || uiToolButton.down

                PropertyChanges {
                    target  : background
                    color   : uiToolButton.visualStyle ?
                                  uiToolButton.visualStyle.selectionColor :
                                  UiColors.getColor(UiColors.SelectionGreen)
                    visible : true
                }
            },
            State {
                name : "hovered"
                when : uiToolButton.hovered || uiToolButton.activeFocus

                PropertyChanges {
                    target  : background
                    color   : uiToolButton.visualStyle ?
                                  uiToolButton.visualStyle.hoverColor :
                                  UiColors.getColor(UiColors.HoverGreen)
                    visible : true
                }
            }
        ]
    }

    Loader {
        id : content

        anchors.fill : parent
        source : (uiToolButton.style === Ui.IconOnly ||
                  uiToolButton.text.length === 0)
                 ? "private/UiToolButtonIconOnly.qml"
                 : "private/UiToolButtonIconAndText.qml"
    }
}

